<?php

namespace App\Filament\Resources\InstallmentSchedules\Pages;

use App\Filament\Resources\ClientReceipts\ClientReceiptResource;
use App\Filament\Resources\InstallmentSchedules\InstallmentScheduleResource;
use Filament\Actions\Action;
use Filament\Resources\Pages\ListRecords;

class ListInstallmentSchedules extends ListRecords
{
    protected static string $resource = InstallmentScheduleResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('create-receipt')
                ->label('إضافة وصل')
                ->icon('heroicon-o-plus-circle')
                ->url(ClientReceiptResource::getUrl('create')),
        ];
    }
}
