<?php

namespace App\Filament\Resources\InstallmentSchedules;

use UnitEnum;
use BackedEnum;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use App\Models\InstallmentSchedule;
use ToneGabes\Filament\Icons\Enums\Phosphor;
use App\Filament\Resources\ClientReceipts\Pages\CreateClientReceipt;
use App\Filament\Resources\InstallmentSchedules\Pages\EditInstallmentSchedule;
use App\Filament\Resources\InstallmentSchedules\Pages\ListInstallmentSchedules;
use App\Filament\Resources\InstallmentSchedules\Pages\CreateInstallmentSchedule;
use App\Filament\Resources\InstallmentSchedules\Schemas\InstallmentScheduleForm;
use App\Filament\Resources\InstallmentSchedules\Tables\InstallmentSchedulesTable;

class InstallmentScheduleResource extends Resource
{
    protected static ?string $model = InstallmentSchedule::class;

    protected static string|BackedEnum|null $navigationIcon = Phosphor::Money;
    protected static string|UnitEnum|null  $navigationGroup = NavGroups::Accounts;
    protected static ?string $navigationLabel               = 'الأقساط';
    protected static ?string $modelLabel                    = 'وصل للعميل';
    protected static ?string $pluralModelLabel              = 'الأقساط';
    protected static ?int $navigationSort                   = 80;
    protected static ?string $recordTitleAttribute          = 'sequence';

    public static function form(Schema $schema): Schema
    {
        return InstallmentScheduleForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return InstallmentSchedulesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index'     => ListInstallmentSchedules::route('/'),
            'create'    => CreateClientReceipt::route('/create'),
            // 'edit'      => EditInstallmentSchedule::route('/{record}/edit'),
        ];
    }
}
