<?php

namespace App\Filament\Resources\Finance\Settleds;

use App\Filament\Resources\Finance\Settleds\Pages\ListSettleds;
use App\Filament\Resources\Finance\Settleds\Tables\SettledsTable;
use App\Models\Client;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class SettledResource extends Resource
{
    protected static ?string $model = Client::class;

    protected static string|UnitEnum|null $navigationGroup = NavGroups::Accounts;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::CheckBadge;

    protected static ?string $navigationLabel = 'ديون مسدَّدة';

    protected static ?string $modelLabel = 'دين مسدَّد';

    protected static ?string $pluralModelLabel = 'ديون مسدَّدة';

    protected static ?string $recordTitleAttribute = 'name';

    protected static ?int $navigationSort = 43;

    public static function form(Schema $schema): Schema
    {
        return $schema;
    }

    public static function table(Table $table): Table
    {
        return SettledsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListSettleds::route('/'),
        ];
    }
}
