<?php

namespace App\Filament\Resources\Finance\Expenses\Pages;

use Illuminate\Database\Eloquent\Model;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Resources\Finance\Expenses\ExpenseResource;
use App\Services\Finance\RecordExpense;
use App\Models\Vault;
use Filament\Notifications\Notification;
use Filament\Support\Exceptions\Halt;

class CreateExpense extends CreateRecord
{
    protected static string $resource = ExpenseResource::class;

    /**
     * نتحقق من الرصيد قبل التنفيذ ونثبت amount كعدد صحيح.
     */
    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // تنظيف المبلغ من أي فواصل/رموز
        $amount = (int) preg_replace('/\D+/', '', (string) ($data['amount'] ?? 0));

        $vault = Vault::forBranch(user_info('branch_id'));

        if ($vault->balance <= 0) {
            Notification::make()
                ->title('رصيد الخزنة صفر')
                ->body('لا يمكن تسجيل مصروف ما لم يكن هناك رصيد متاح.')
                ->danger()
                ->send();

            throw new Halt(); // يوقف العملية بدون صفحة خطأ
        }

        if ($vault->balance < $amount) {
            Notification::make()
                ->title('الرصيد غير كافٍ')
                ->body('رصيد الخزنة أقل من قيمة المصروف.')
                ->warning()
                ->send();

            throw new Halt();
        }

        // ثبّت المبلغ كقيمة صحيحة
        $data['amount'] = $amount;

        return $data;
    }

    /**
     * تنفيذ الإنشاء عبر الخدمة. لو رجعت null نوقف العملية برشاقة.
     */
    protected function handleRecordCreation(array $data): Model
    {
        $expense = RecordExpense::create(
            categoryId: (int) $data['expense_category_id'],
            amount: (int) $data['amount'],
            description: $data['description'] ?? null,
            spentAt: $data['spent_at'] ?? null,
        );

        if (! $expense) {
            // احتياط (يفترض أننا وقفنا بالـ mutate أعلاه)
            Notification::make()
                ->title('تعذّر تسجيل المصروف')
                ->body('تأكد من رصيد الخزنة ثم حاول مرة أخرى.')
                ->danger()
                ->send();

            throw new Halt();
        }

        return $expense;
    }
}
