<?php

namespace App\Filament\Resources\Finance\Expenses;

use BackedEnum;
use UnitEnum;
use App\Models\Expense;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\Finance\Expenses\Pages\EditExpense;
use App\Filament\Resources\Finance\Expenses\Pages\ListExpenses;
use App\Filament\Resources\Finance\Expenses\Pages\CreateExpense;
use App\Filament\Resources\Finance\Expenses\Schemas\ExpenseForm;
use App\Filament\Resources\Finance\Expenses\Tables\ExpensesTable;

class ExpenseResource extends Resource
{
    protected static ?string $model = Expense::class;
    protected static string|UnitEnum|null $navigationGroup      = NavGroups::Finance;
    protected static string|BackedEnum|null $navigationIcon     = Heroicon::ArrowTrendingDown;
    protected static ?string $navigationLabel                   = 'المصروفات';
    protected static ?string $modelLabel                        = 'مصروف';
    protected static ?string $pluralModelLabel                  = 'المصروفات';
    protected static ?string $recordTitleAttribute              = 'id';
    protected static ?int $navigationSort                       = 32;

    public static function form(Schema $schema): Schema
    {
        return ExpenseForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ExpensesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListExpenses::route('/'),
            'create' => CreateExpense::route('/create'),
            'edit'   => EditExpense::route('/{record}/edit'),
        ];
    }
}
