<?php

namespace App\Filament\Resources\Finance\ExpenseCategories\Schemas;

use Filament\Schemas\Schema;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Checkbox;

class ExpenseCategoryForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('اسم التصنيف')
                    ->required()
                    ->maxLength(100),

                Checkbox::make('is_active')
                    ->label('مفعّل')
                    ->default(true)
                    ->visibleOn('edit')
                    ->helperText('إذا لم يتم تحديده، لن يكون التصنيف متاحًا للاستخدام.'),
            ])
            ->columns(1);
    }
}
