<?php

namespace App\Filament\Resources\Finance\ExpenseCategories\Pages;

use App\Filament\Resources\Finance\ExpenseCategories\ExpenseCategoryResource;
use Filament\Actions\CreateAction;
use Filament\Resources\Pages\ListRecords;

class ListExpenseCategories extends ListRecords
{
    protected static string $resource = ExpenseCategoryResource::class;

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make()
                ->label('إضافة تصنيف')
                ->mutateDataUsing(function (array $data): array {
                    $data['branch_id'] = (int) (user_info('branch_id') ?? 0);
                    return $data;
                }),
        ];
    }
}
