<?php

namespace App\Filament\Resources\Finance\ExpenseCategories\Pages;

use App\Filament\Resources\Finance\ExpenseCategories\ExpenseCategoryResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Auth;

class CreateExpenseCategory extends CreateRecord
{
    protected static string $resource = ExpenseCategoryResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['branch_id'] = (int) (user_info('branch_id') ?? 0);
        return $data;
    }
}
