<?php

namespace App\Filament\Resources\Finance\ExpenseCategories;

use BackedEnum;
use UnitEnum;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use App\Models\ExpenseCategory;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\Finance\ExpenseCategories\Pages\ListExpenseCategories;
use App\Filament\Resources\Finance\ExpenseCategories\Schemas\ExpenseCategoryForm;
use App\Filament\Resources\Finance\ExpenseCategories\Tables\ExpenseCategoriesTable;
use App\Support\NavGroups;

class ExpenseCategoryResource extends Resource
{
    protected static ?string $model = ExpenseCategory::class;

    protected static string|UnitEnum|null $navigationGroup      = NavGroups::Finance;
    protected static string|BackedEnum|null $navigationIcon     = Heroicon::OutlinedTag;
    protected static ?string $navigationLabel                   = 'التصنيفات';
    protected static ?string $modelLabel                        = 'تصنيف';
    protected static ?string $pluralModelLabel                  = 'التصنيفات ';
    protected static ?string $recordTitleAttribute              = 'name';
    protected static ?int $navigationSort                       = 31;

    public static function form(Schema $schema): Schema
    {
        return ExpenseCategoryForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ExpenseCategoriesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index'  => ListExpenseCategories::route('/'),
            // 'create' => CreateExpenseCategory::route('/create'),
            // 'edit'   => EditExpenseCategory::route('/{record}/edit'),
        ];
    }
}
