<?php

namespace App\Filament\Resources\Finance\Debtors\Pages;

use App\Filament\Resources\ClientReceipts\ClientReceiptResource;
use App\Filament\Resources\Finance\Debtors\DebtorsResource;
use App\Filament\Resources\Finance\Debtors\Widgets\DebtorsStatsWidget;
use Filament\Actions\Action;
use Filament\Resources\Pages\ListRecords;

class ListDebtors extends ListRecords
{
    protected static string $resource = DebtorsResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('create-receipt')
                ->label('إضافة وصل')
                ->icon('heroicon-o-plus-circle')
                ->url(ClientReceiptResource::getUrl('create')),
        ];
    }

    protected function getHeaderWidgets(): array
    {
        return [
            DebtorsStatsWidget::class,
        ];
    }
}
