<?php

namespace App\Filament\Resources\Finance\Debtors;

use App\Filament\Resources\Finance\Debtors\Pages\ListDebtors;
use App\Filament\Resources\Finance\Debtors\Tables\DebtorsTable;
use App\Models\Client;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use UnitEnum;

class DebtorsResource extends Resource
{
    protected static ?string $model = Client::class;

    protected static string|UnitEnum|null $navigationGroup = NavGroups::Accounts;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::CurrencyDollar;

    protected static ?string $navigationLabel = 'الديون';

    protected static ?string $modelLabel = 'ديون عميل';

    protected static ?string $pluralModelLabel = 'الديون';

    protected static ?int $navigationSort = 42;

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return $schema;
    }

    public static function table(Table $table): Table
    {
        return DebtorsTable::configure($table);
    }

    /**
     * ✅ إظهار العملاء الذين عليهم ديون فقط (الذمم المدينة)
     * - يعتمد على client_accounts.receivable_remaining (عدد صحيح)
     * - يفلتر حسب الفرع الحالي من user_info('branch_id')
     */
    public static function getEloquentQuery(): Builder
    {
        $branchId = (int) user_info('branch_id');

        return parent::getEloquentQuery()
            ->select('clients.*')
            ->join('client_accounts as ca', function ($join) use ($branchId) {
                $join->on('ca.client_id', '=', 'clients.id')
                    ->where('ca.branch_id', '=', $branchId);
            })
            ->where('ca.receivable_remaining', '>', 0) // ✅ ديون فقط
            ->orderByDesc('ca.receivable_remaining');  // ✅ الأكبر ديناً أولاً
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListDebtors::route('/'),
        ];
    }
}
