<?php

namespace App\Filament\Resources\ExchangeRates\Pages;

use App\Models\ExchangeRate;
use Filament\Actions\CreateAction;
use Filament\Resources\Pages\ManageRecords;
use App\Filament\Resources\ExchangeRates\ExchangeRateResource;

class ManageExchangeRates extends ManageRecords
{
    protected static string $resource = ExchangeRateResource::class;

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make()
                ->label('إضافة سعر جديد')
                ->after(function ($record) {
                    // لو صار هذا السجل مفعلاً، عطّل غيره لنفس العملة
                    if ($record->is_active) {
                        ExchangeRate::where('currency_id', $record->currency_id)
                            ->where('id', '!=', $record->id)
                            ->update(['is_active' => false]);
                    }
                }),
        ];
    }
}
