<?php

namespace App\Filament\Resources\Employees\Tables;

use Filament\Tables\Table;
use Filament\Actions\ActionName;
use Filament\Actions\EditAction;
use Filament\Actions\ActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;

class EmployeesTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('الاسم الثلاثي')
                    ->searchable(),
                TextColumn::make('phone')
                    ->label('الهاتف')
                    ->searchable(),
                TextColumn::make('PayGrade.name')
                    ->label('الوظيفة')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: false),
                TextColumn::make('gender')
                    ->label('الجنس')
                    ->formatStateUsing(fn(string $state): string => match ($state) {
                        'male' => 'ذكر',
                        'female' => 'أنثى',
                    })
                    ->badge()
                    ->toggleable(isToggledHiddenByDefault: false),
                TextColumn::make('salary_type')
                    ->label('نوع الراتب')
                    ->formatStateUsing(fn(string $state): string => match ($state) {
                        'monthly'   => 'شهري',
                        'daily'     => 'يومي',
                    })
                    ->badge()
                    ->toggleable(isToggledHiddenByDefault: false),
                TextColumn::make('hired_at')
                    ->label('تاريخ التعيين')
                    ->date('Y-m-d')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: false),
                IconColumn::make('is_active')
                    ->label('الحالة')
                    ->boolean()
                    ->toggleable(isToggledHiddenByDefault: false),
                TextColumn::make('branch.name')
                    ->label('الفروع')
                    ->visible(fn() => auth()->user()?->hasRole('admin'))
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('user.name')
                    ->label('الموظف')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->label('تاريخ التحديث')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                SelectFilter::make('branch_id')
                    ->label('الفروع')
                    ->relationship('branch', 'name')
                    ->visible(fn() => auth()->user()?->hasRole('admin')),

                SelectFilter::make('paygrade')
                    ->label('المستوى الراتب')
                    ->searchable()
                    ->relationship('paygrade', 'name'),
                SelectFilter::make('salary_type')
                    ->label('نوع الراتب')
                    ->searchable()
                    ->options([
                        'monthly' => 'شهري',
                        'daily' => 'يومي',
                    ]),
                SelectFilter::make('gender')
                    ->label('الجنس')
                    ->searchable()
                    ->options([
                        'male' => 'ذكر',
                        'female' => 'أنثى',
                    ]),
                SelectFilter::make('is_active')
                    ->label('الحالة')
                    ->searchable()
                    ->options([
                        '1' => 'نشط',
                        '0' => 'متوقف',
                    ]),
                //
            ])
            ->recordActions([
                ActionGroup::make([
                    EditAction::make(),
                    DeleteAction::make(),
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
