<?php

namespace App\Filament\Resources\Employees\Schemas;

use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Forms\Components\DatePicker;

class EmployeeForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('معلومات الموظف')
                    ->description('أدخل بيانات الموظف الأساسية')
                    ->schema([
                        Select::make('branch_id')
                            ->label('الفرع')
                            ->relationship('branch', 'name')
                            ->searchable()
                            ->preload()
                            ->required()
                            ->placeholder('اختر الفرع')
                            ->visible(fn() => auth()->user()?->hasRole('admin'))
                            ->default(
                                fn() => !auth()->user()?->hasRole('admin')
                                    ? auth()->user()?->branch_id
                                    : null
                            ),

                        Select::make('pay_grade_id')
                            ->label('الدرجة الوظيفية')
                            ->relationship('payGrade', 'name')
                            ->searchable()
                            ->preload()
                            ->placeholder('اختر الدرجة'),

                        TextInput::make('name')
                            ->label('الاسم')
                            ->required()
                            ->maxLength(255)
                            ->placeholder('أدخل اسم الموظف'),

                        TextInput::make('phone')
                            ->label('رقم الهاتف')
                            ->tel()
                            ->maxLength(11)
                            ->extraInputAttributes([
                                'dir' => 'ltr',
                                'class' => 'text-right',
                            ])
                            ->placeholder('أدخل رقم الهاتف'),

                        TextInput::make('address')
                            ->label('العنوان')
                            ->maxLength(255)
                            ->placeholder('أدخل العنوان الكامل'),

                        Select::make('gender')
                            ->label('الجنس')
                            ->options([
                                'male' => 'ذكر',
                                'female' => 'أنثى'
                            ])
                            ->native(false)
                            ->placeholder('اختر الجنس'),

                        Select::make('salary_type')
                            ->label('نوع الراتب')
                            ->options([
                                'monthly' => 'شهري',
                                'daily' => 'يومي'
                            ])
                            ->default('monthly')
                            ->required()
                            ->native(false)
                            ->placeholder('اختر نوع الراتب'),

                        DatePicker::make('hired_at')
                            ->label('تاريخ التوظيف')
                            ->native(false)
                            ->displayFormat('d/m/Y')
                            ->placeholder('اختر التاريخ'),

                        Select::make('is_active')
                            ->label('نشط')
                            ->options([
                                '1' => 'نشط',
                                '0' => 'غير نشط'
                            ])
                            ->default(true)
                            ->visibleOn('edit')
                            ->required(),
                    ])
                    ->columns(2)
                    ->columnSpanFull(),
            ]);
    }
}
