<?php

namespace App\Filament\Resources\Currencies;

use UnitEnum;
use BackedEnum;
use App\Models\Currency;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Actions\EditAction;
use Filament\Resources\Resource;
use Filament\Actions\ActionGroup;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteAction;
use Filament\Support\Icons\Heroicon;
use Filament\Actions\BulkActionGroup;
use Filament\Forms\Components\Toggle;
use Filament\Actions\DeleteBulkAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Filters\SelectFilter;
use App\Filament\Resources\Currencies\Pages\ManageCurrencies;

class CurrencyResource extends Resource
{
    protected static ?string $model = Currency::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::CreditCard;
    protected static string|UnitEnum|null  $navigationGroup = NavGroups::Dashboard;
    protected static ?string $navigationLabel               = 'العملات';
    protected static ?string $modelLabel                    = 'تصنيف';
    protected static ?string $pluralModelLabel              = 'العملات';
    protected static ?int $navigationSort                   = 10;
    protected static ?string $recordTitleAttribute          = 'name';

    public static function canGloballySearch(): bool
    {
        return false;
    }
    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('الاسم')
                    ->required(),

                TextInput::make('code')
                    ->label('رمز العملة')
                    ->required()
                    ->maxLength(3)
                    ->unique(ignoreRecord: true)
                    ->rule('uppercase'),

                Toggle::make('is_active')
                    ->label('الحالة')
                    ->default(true),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                TextColumn::make('name')
                    ->label('الاسم')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('code')
                    ->label('الرمز')
                    ->sortable(),
                IconColumn::make('is_active')
                    ->boolean()
                    ->label('مفعلة'),
                TextColumn::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime('Y-m-d h:i A') // ← لاحظ h بدل H و A لعرض AM/PM
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('updated_at')
                    ->label('تاريخ التحديث')
                    ->dateTime('Y-m-d h:i A')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

            ])
            ->filters([
                //
                SelectFilter::make('is_active')
                    ->label('الحالة')
                    ->options([
                        true    => 'مفعلة',
                        false   => 'متوقف',
                    ]),
            ])
            ->recordActions([
                ActionGroup::make([
                    EditAction::make(),
                    DeleteAction::make(),
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make()->label('إضافة عملة جديدة'),
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ManageCurrencies::route('/'),
        ];
    }
}
