<?php

namespace App\Filament\Resources\Clients\Widgets;

use App\Models\Client;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Database\Eloquent\Model;

class ClientStatsOverview extends StatsOverviewWidget
{
    /** يُمرَّر من الـ Blade */
    public ?int $recordId = null;

    /** تعديل عدد الأعمدة داخليًا (مثلاً 1 مع عرض 200px) */
    public array|int|null $columns = 3;

    /** السجل الداخلي */
    public ?Model $record = null;

    /** إيقاف التحديث الدوري */
    protected ?string $pollingInterval = null;

    protected int|string|array $columnSpan = ['md' => 3, 'xl' => 3];

    protected function getRecords(): ?Model
    {
        return $this->record;
    }

    public function mount(): void
    {
        if ($this->recordId) {
            $this->record = Client::query()->find($this->recordId);
        }
    }

    /** عدد أعمدة كروت الإحصاءات داخل نفس الودجت */
    protected function getColumns(): array|int|null
    {
        return $this->columns; // بدّلها من الـ Blade عند الحاجة
    }

    /** ربط الـ CSS المخصص */
    protected function getExtraAttributes(): array
    {
        return ['class' => 'fi-compact-stats-box'];
    }

    protected function getStats(): array
    {
        /** @var Client|null $c */
        $c = $this->record;
        if (! $c) {
            return [];
        }

        $ordersTotal = (int) $c->orders()->sum('total_price');
        $paid        = (int) $c->orders()->sum('paid');
        $debt        = max(0, $ordersTotal - $paid);

        $fmt = fn(int $v) => 'د.ع ' . number_format($v);

        return [
            Stat::make('قيمة الطلبات', $fmt($ordersTotal))
                ->description('إجمالي')
                ->descriptionIcon('heroicon-m-banknotes')
                ->color('gray')
                ->extraAttributes([
                    'class' => 'fi-compact-stat stat--neutral stat--small'
                ]),

            Stat::make('المدفوع', $fmt($paid))
                ->description('مدفوع')
                ->descriptionIcon('heroicon-m-arrow-trending-up')
                ->color('success')
                ->extraAttributes([
                    'class' => 'fi-compact-stat stat--success stat--small'
                ]),

            Stat::make('المتبقي', $fmt($debt))
                ->description($debt > 0 ? 'دين على العميل' : 'لا يوجد دين')
                ->descriptionIcon($debt > 0 ? 'heroicon-m-arrow-trending-down' : 'heroicon-m-check-badge')
                ->color($debt > 0 ? 'danger' : 'success')
                ->extraAttributes([
                    'class' => 'fi-compact-stat ' . ($debt > 0 ? 'stat--danger' : 'stat--success-soft') . ' stat--small'
                ]),
        ];
    }
}
