<?php

namespace App\Filament\Resources\Clients\Schemas;

use App\Models\City;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;

class ClientForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Section::make('اضافة العميل')
                    ->description('يرجى ملء جميع الحقول المطلوبة')
                    ->columns(2)
                    ->columnSpanFull()
                    ->components([
                        Select::make('branch_id')
                            ->relationship('branch', 'name')
                            ->label('الفروع')
                            ->visibleOn(user_info()->hasRole('admin'))
                            ->required(),
                        TextInput::make('name')
                            ->label('الاسم')
                            ->required(),
                        TextInput::make('company')
                            ->label('الشركة'),
                        TextInput::make('phone')
                            ->label('رقم الهاتف')
                            ->tel()
                            ->maxLength(11)
                            ->extraInputAttributes([
                                'dir' => 'ltr',
                                'class' => 'text-right',
                            ])
                            ->required(),
                        TextInput::make('phone2')
                            ->label('رقم الهاتف الثاني')
                            ->maxLength(11)
                            ->extraInputAttributes([
                                'dir' => 'ltr',
                                'class' => 'text-right',
                            ])
                            ->tel(),
                        // المحافظة
                        Select::make('city')
                            ->label('المحافظة')
                            ->options(City::query()->pluck('name', 'id'))
                            ->searchable()
                            ->preload()
                            ->native(false)
                            ->required(),

                        TextInput::make('address')
                            ->label('العنوان'),
                        Toggle::make('is_active')
                            ->label('الحالة')
                            ->default(true)
                            ->visibleOn(user_info()->hasRole('admin'))
                            ->required(),
                    ])
            ])
            ->columns(2);
    }
}
