<?php

namespace App\Filament\Resources\Clients\Pages;

use Filament\Actions\Action;
use Filament\Schemas\Schema;
use Filament\Actions\EditAction;
use Filament\Support\Icons\Heroicon;
use Filament\Schemas\Components\Grid;
use Filament\Support\Enums\FontWeight;
use Filament\Resources\Pages\ViewRecord;
use Filament\Support\Enums\IconPosition;
use Filament\Schemas\Components\Tabs\Tab;
use Filament\Infolists\Components\ImageEntry;
use Filament\Schemas\Components\{Section, Tabs};
use App\Filament\Resources\Clients\ClientResource;
use Filament\Infolists\Components\{TextEntry, ViewEntry};

class ViewClient extends ViewRecord
{
    protected static string $resource = ClientResource::class;

    protected function getHeaderActions(): array
    {
        return [
            EditAction::make(),
            Action::make('back')
                ->label('رجوع')
                ->icon('heroicon-o-arrow-uturn-left')
                ->url(static::getResource()::getUrl())
                ->color('gray'),
        ];
    }

    public function infolist(Schema $schema): Schema
    {
        return $schema->components([
            Section::make()
                ->schema([
                    // الهيدر المخصص
                    ViewEntry::make('profileHeader')
                        ->view('filament/clients/profile-header')   // نفس الملف السابق
                        ->columnSpanFull(),
                    Section::make()
                        ->description('معلومات العميل')
                        ->icon(Heroicon::UserCircle)
                        ->schema([
                            Grid::make(3)->schema([
                                TextEntry::make('name')
                                    ->label('الاسم')
                                    ->extraAttributes(['class' => 'text-lg'])
                                    ->weight(FontWeight::Medium),

                                TextEntry::make('phone_husband')
                                    ->label('هاتف الزوج')
                                    ->copyable()
                                    ->state(function ($record) {
                                        $p = $record->phone ?? null;
                                        return (is_array($p) && isset($p[0]) && filled($p[0])) ? $p[0] : '—';
                                    }),

                                TextEntry::make('phone_wife')
                                    ->label('هاتف الزوجة')
                                    ->copyable()
                                    ->state(function ($record) {
                                        $p = $record->phone ?? null;
                                        return (is_array($p) && isset($p[1]) && filled($p[1])) ? $p[1] : '—';
                                    }),

                                TextEntry::make('address')
                                    ->label('العنوان')
                                    ->icon('heroicon-o-map-pin')
                                    ->default('—'),

                                TextEntry::make('status')
                                    ->label('الحالة')
                                    ->badge()
                                    ->state(fn($record) => ((int) ($record->status ?? 0)) === 1 ? 'نشط' : 'غير نشط')
                                    ->color(fn($record) => ((int) ($record->status ?? 0)) === 1 ? 'success' : 'danger'),

                                TextEntry::make('user.name')
                                    ->label('أضيف بواسطة')
                                    ->icon('heroicon-o-user'),
                            ]),
                        ])
                        ->columnSpanFull(),
                ])
                // شكل الكارد العام (نفس إطار الهيدر)
                ->columns(1)
                ->extraAttributes([
                    'class' => 'rounded-2xl ring-1 ring-gray-200/60 shadow-sm overflow-hidden bg-white',
                ])->columnSpanFull(),
        ]);
    }
}
