<?php

namespace App\Filament\Resources\ClientReceipts\Schemas;

use App\Models\ClientReceipt;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class ClientReceiptInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('receipt_number'),
                TextEntry::make('year')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('sequence')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('client.name')
                    ->label('Client'),
                TextEntry::make('invoice.id')
                    ->label('Invoice')
                    ->placeholder('-'),
                TextEntry::make('client_installment_plan_id')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('vault.id')
                    ->label('Vault')
                    ->placeholder('-'),
                TextEntry::make('branch.name')
                    ->label('Branch')
                    ->placeholder('-'),
                TextEntry::make('receipt_date')
                    ->date(),
                TextEntry::make('amount')
                    ->numeric(),
                TextEntry::make('payment_type')
                    ->badge(),
                TextEntry::make('payment_details')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('issued_by')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('status')
                    ->badge(),
                TextEntry::make('cancelled_by')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('cancelled_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('cancel_reason')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('deleted_at')
                    ->dateTime()
                    ->visible(fn (ClientReceipt $record): bool => $record->trashed()),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
            ]);
    }
}
