<?php

namespace App\Filament\Resources\ClientReceipts\Pages;

use App\Filament\Resources\ClientReceipts\ClientReceiptResource;
use App\Models\ClientReceipt;
use App\Services\Accounting\Receipts\CreateClientReceiptService;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;

class CreateClientReceipt extends CreateRecord
{
    protected static string $resource = ClientReceiptResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // لو تحب تضمن branch_id من هنا أيضًا (احتياطي):
        if (empty($data['branch_id']) && function_exists('user_info')) {
            $data['branch_id'] = (int) (user_info('branch_id') ?? 0);
        }

        // تأكيد نوع الوصل
        $data['receipt_type'] = $data['receipt_type'] ?? 'collection';

        return $data;
    }

    protected function handleRecordCreation(array $data): ClientReceipt
    {
        try {
            /** @var CreateClientReceiptService $svc */
            $svc = app(CreateClientReceiptService::class);

            $receipt = $svc->execute($data);

            Notification::make()
                ->title('تم إنشاء الوصل')
                ->body('تم الحفظ مع التوزيع على الفواتير وتحديث الحسابات.')
                ->success()
                ->send();

            return $receipt;
        } catch (\Throwable $e) {
            report($e);

            Notification::make()
                ->title('تعذّر إنشاء الوصل')
                ->body('حدث خطأ أثناء الإنشاء المحاسبي.')
                ->danger()
                ->send();

            throw $e;
        }
    }

    protected function getRedirectUrl(): string
    {
        return static::getResource()::getUrl('view', ['record' => $this->record]);
    }
}
