<?php

namespace App\Filament\Resources\ClientReceipts;

use App\Filament\Resources\ClientReceipts\Pages\CreateClientReceipt;
use App\Filament\Resources\ClientReceipts\Pages\EditClientReceipt;
use App\Filament\Resources\ClientReceipts\Pages\ListClientReceipts;
use App\Filament\Resources\ClientReceipts\Pages\ViewClientReceipt;
use App\Filament\Resources\ClientReceipts\Schemas\ClientReceiptForm;
use App\Filament\Resources\ClientReceipts\Schemas\ClientReceiptInfolist;
use App\Filament\Resources\ClientReceipts\Tables\ClientReceiptsTable;
use App\Models\ClientReceipt;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use ToneGabes\Filament\Icons\Enums\Phosphor;
use UnitEnum;

class ClientReceiptResource extends Resource
{
    protected static ?string $model = ClientReceipt::class;

    protected static string|BackedEnum|null $navigationIcon = Phosphor::Receipt;

    protected static string|UnitEnum|null $navigationGroup = NavGroups::Accounts;

    protected static ?string $navigationLabel = 'الوصولات';

    protected static ?string $modelLabel = 'وصل';

    protected static ?string $pluralModelLabel = 'الوصولات';

    protected static ?int $navigationSort = 82;

    protected static ?string $recordTitleAttribute = 'receipt_number';

    public static function form(Schema $schema): Schema
    {
        return ClientReceiptForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return ClientReceiptInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ClientReceiptsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListClientReceipts::route('/'),
            'create' => CreateClientReceipt::route('/create'),
            'view' => ViewClientReceipt::route('/{record}'),
            'edit' => EditClientReceipt::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
