<?php

namespace App\Filament\Resources\ClientDiscounts\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Components\Utilities\Get;
use Filament\Schemas\Schema;

class ClientDiscountForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->components([
            Section::make('خصم العميل')
                ->description('تحديد خصم خاص للعميل')
                ->icon('heroicon-o-receipt-percent')
                ->collapsible()
                ->columnSpanFull()
                ->schema([
                    Grid::make(2)->schema([
                        Select::make('client_id')
                            ->label('العميل')
                            ->relationship('client', 'name')
                            ->required()
                            ->searchable()
                            ->preload()
                            ->prefixIcon('heroicon-o-user')
                            ->createOptionForm([
                                TextInput::make('name')
                                    ->label('اسم العميل')
                                    ->required()
                                    ->maxLength(255),
                                TextInput::make('phone')
                                    ->label('رقم الهاتف')
                                    ->tel()
                                    ->maxLength(20),
                                TextInput::make('email')
                                    ->label('البريد الإلكتروني')
                                    ->email()
                                    ->maxLength(255),
                            ]),

                        Select::make('discount_type')
                            ->label('نوع الخصم')
                            ->options([
                                'percentage' => 'نسبة مئوية',
                                'fixed' => 'مبلغ ثابت',
                            ])
                            ->required()
                            ->default('percentage')
                            ->live()
                            ->prefixIcon('heroicon-o-sparkles'),

                        TextInput::make('discount_value')
                            ->label(fn (Get $get) => $get('discount_type') === 'percentage' ? 'نسبة الخصم %' : 'مبلغ الخصم')
                            ->numeric()
                            ->required()
                            ->minValue(0)
                            ->maxValue(fn (Get $get) => $get('discount_type') === 'percentage' ? 100 : null)
                            ->suffix(fn (Get $get) => $get('discount_type') === 'percentage' ? '%' : 'د.ع')
                            ->prefixIcon('heroicon-o-calculator'),

                        Toggle::make('is_active')
                            ->label('مفعّل')
                            ->default(true)
                            ->inline(false),

                        DateTimePicker::make('starts_at')
                            ->label('يبدأ في')
                            ->placeholder('فوري')
                            ->helperText('اترك فارغاً للبدء فوراً')
                            ->prefixIcon('heroicon-o-play'),

                        DateTimePicker::make('ends_at')
                            ->label('ينتهي في')
                            ->placeholder('بدون نهاية')
                            ->helperText('اترك فارغاً لعدم وجود نهاية')
                            ->afterOrEqual('starts_at')
                            ->prefixIcon('heroicon-o-stop'),

                        Textarea::make('notes')
                            ->label('ملاحظات')
                            ->rows(2)
                            ->placeholder('ملاحظات حول الخصم...')
                            ->columnSpanFull(),
                    ]),
                ]),
        ]);
    }
}
