<?php

namespace App\Filament\Resources\ClientDiscounts;

use App\Filament\Resources\ClientDiscounts\Pages\CreateClientDiscount;
use App\Filament\Resources\ClientDiscounts\Pages\EditClientDiscount;
use App\Filament\Resources\ClientDiscounts\Pages\ListClientDiscounts;
use App\Filament\Resources\ClientDiscounts\Schemas\ClientDiscountForm;
use App\Filament\Resources\ClientDiscounts\Tables\ClientDiscountsTable;
use App\Models\ClientDiscount;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class ClientDiscountResource extends Resource
{
    protected static ?string $model = ClientDiscount::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedUserGroup;

    protected static ?string $navigationLabel = 'خصومات العملاء';

    protected static ?string $modelLabel = 'خصم عميل';

    protected static ?string $pluralModelLabel = 'خصومات العملاء';

    protected static string|UnitEnum|null $navigationGroup = NavGroups::PROMOTIONS;

    protected static ?int $navigationSort = 3;

    public static function form(Schema $schema): Schema
    {
        return ClientDiscountForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ClientDiscountsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListClientDiscounts::route('/'),
            'create' => CreateClientDiscount::route('/create'),
            'edit' => EditClientDiscount::route('/{record}/edit'),
        ];
    }
}
