<?php

namespace App\Filament\Resources\Categories\Schemas;

use App\Models\Category;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;

class CategoryForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->columns(12)
            ->components([
                Section::make('بيانات التصنيف')
                    ->columns(12)
                    ->columnSpanFull()
                    ->schema([
                        TextInput::make('name')
                            ->label('اسم التصنيف')
                            ->placeholder('أدخل اسم التصنيف')
                            ->required()
                            ->maxLength(120)
                            ->columnSpan(6),

                        Select::make('parent_id')
                            ->label('التصنيف الأب (اختياري)')
                            ->relationship('parent', 'name')
                            ->options(
                                Category::query()
                                    ->whereNull('parent_id')
                                    ->orderBy('name')
                                    ->pluck('name', 'id')
                            )
                            ->searchable()
                            ->preload()
                            ->nullable()
                            ->columnSpan(6),

                        Toggle::make('is_active')
                            ->label('نشط')
                            ->default(true)
                            ->columnSpan(12),
                    ]),
            ]);
    }
}
