<?php

namespace App\Filament\Resources\Categories;

use UnitEnum;
use BackedEnum;
use App\Models\Category;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\Categories\Pages\EditCategory;
use App\Filament\Resources\Categories\Pages\CreateCategory;
use App\Filament\Resources\Categories\Pages\ListCategories;
use App\Filament\Resources\Categories\Schemas\CategoryForm;
use App\Filament\Resources\Categories\Tables\CategoriesTable;
use App\Filament\Clusters\ProductManagement\ProductManagementCluster;

class CategoryResource extends Resource
{
    protected static ?string $model                         = Category::class;
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static string|UnitEnum|null  $navigationGroup = NavGroups::PRODUCTS;
    protected static ?string $navigationLabel               = 'التصنيفات';
    protected static ?string $modelLabel                    = 'تصنيف';
    protected static ?string $pluralModelLabel              = 'التصنيفات';
    protected static ?int $navigationSort                   = 61;
    protected static ?string $recordTitleAttribute          = 'name';

    public static function form(Schema $schema): Schema
    {
        return CategoryForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return CategoriesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListCategories::route('/'),
            'create' => CreateCategory::route('/create'),
            'edit' => EditCategory::route('/{record}/edit'),
        ];
    }
}
