<?php

namespace App\Filament\Resources\Campaigns\Tables;

use Filament\Actions\ActionGroup;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Filters\TernaryFilter;
use Filament\Tables\Table;

class CampaignsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('اسم الحملة')
                    ->searchable()
                    ->sortable()
                    ->weight('bold'),

                TextColumn::make('type')
                    ->label('النوع')
                    ->badge()
                    ->formatStateUsing(fn (string $state) => match ($state) {
                        'email' => 'بريد إلكتروني',
                        'sms' => 'رسائل نصية',
                        'notification' => 'إشعارات',
                        'banner' => 'بانر',
                        default => $state,
                    })
                    ->color('info'),

                TextColumn::make('starts_at')
                    ->label('تبدأ')
                    ->dateTime('Y-m-d')
                    ->sortable(),

                TextColumn::make('ends_at')
                    ->label('تنتهي')
                    ->dateTime('Y-m-d')
                    ->sortable()
                    ->placeholder('مستمرة'),

                IconColumn::make('is_active')
                    ->label('مفعّل')
                    ->boolean()
                    ->alignCenter()
                    ->sortable(),

                TextColumn::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime('Y-m-d')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                SelectFilter::make('type')
                    ->label('النوع')
                    ->options([
                        'email' => 'بريد إلكتروني',
                        'sms' => 'رسائل نصية',
                        'notification' => 'إشعارات',
                        'banner' => 'بانر',
                    ])
                    ->multiple(),

                TernaryFilter::make('is_active')
                    ->label('الحالة')
                    ->placeholder('الكل')
                    ->trueLabel('مفعّل')
                    ->falseLabel('معطّل'),
            ])
            ->recordActions([
                ActionGroup::make([
                    EditAction::make(),
                    DeleteAction::make()
                        ->requiresConfirmation(),
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->requiresConfirmation(),
                ]),
            ])
            ->defaultSort('created_at', 'desc')
            ->emptyStateHeading('لا توجد حملات')
            ->emptyStateDescription('ابدأ بإضافة حملة تسويقية')
            ->emptyStateIcon('heroicon-o-megaphone')
            ->striped();
    }
}
