<?php

namespace App\Filament\Resources\Campaigns\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;

class CampaignForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->components([
            Section::make('معلومات الحملة')
                ->description('البيانات الأساسية للحملة التسويقية')
                ->icon('heroicon-o-megaphone')
                ->collapsible()
                ->columnSpanFull()
                ->schema([
                    Grid::make(2)->schema([
                        TextInput::make('name')
                            ->label('اسم الحملة')
                            ->required()
                            ->maxLength(255)
                            ->placeholder('مثال: حملة الجمعة البيضاء')
                            ->prefixIcon('heroicon-o-tag'),

                        Select::make('type')
                            ->label('نوع الحملة')
                            ->options([
                                'email' => 'بريد إلكتروني',
                                'sms' => 'رسائل نصية',
                                'notification' => 'إشعارات',
                                'banner' => 'بانر على الموقع',
                            ])
                            ->required()
                            ->default('email')
                            ->prefixIcon('heroicon-o-envelope'),

                        Textarea::make('description')
                            ->label('الوصف')
                            ->rows(2)
                            ->placeholder('وصف الحملة...')
                            ->columnSpanFull(),

                        DateTimePicker::make('starts_at')
                            ->label('تبدأ في')
                            ->required()
                            ->prefixIcon('heroicon-o-play'),

                        DateTimePicker::make('ends_at')
                            ->label('تنتهي في')
                            ->afterOrEqual('starts_at')
                            ->prefixIcon('heroicon-o-stop'),

                        Toggle::make('is_active')
                            ->label('مفعّل')
                            ->default(true)
                            ->inline(false),
                    ]),
                ]),
        ]);
    }
}
