<?php

namespace App\Filament\Resources\Brands\Tables;

use App\Models\Branch;
use Filament\Tables\Table;
use Filament\Actions\EditAction;
use Filament\Actions\ActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;

class BrandsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                //
                TextColumn::make('name')
                    ->label('اسم البراند')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('description')
                    ->label('وصف البراند')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('branch.name')
                    ->label('الفروع')
                    ->badge()
                    ->color('primary')
                    ->searchable()
                    ->visible(auth()->user()->hasRole('admin'))
                    ->sortable(),
                IconColumn::make('is_active')
                    ->label('الحالة')
                    ->boolean()
                    ->trueIcon('heroicon-o-check-circle')
                    ->falseIcon('heroicon-o-x-circle')
                    ->trueColor('success')
                    ->falseColor('danger')
                    ->alignCenter(),
                TextColumn::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime('Y-m-d H:i')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                TextColumn::make('updated_at')
                    ->label('تاريخ التحديث')
                    ->dateTime('Y-m-d H:i')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
                SelectFilter::make('branch_id')
                    ->visible(auth()->user()->hasRole('admin'))
                    ->label('الفروع')
                    ->searchable()
                    ->placeholder('اختر الفروع')
                    ->preload()
                    ->options(
                        Branch::query()
                            ->pluck('name', 'id')
                            ->toArray()
                    ),

                SelectFilter::make('is_active')
                    ->label('الحالة')
                    ->searchable()
                    ->placeholder('اختر الحالة')
                    ->preload()
                    ->options([
                        true    => 'نشط',
                        false   => 'متوقف',
                    ]),
            ])
            ->recordActions([
                ActionGroup::make([
                    EditAction::make(),
                    DeleteAction::make(),
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
