<?php

namespace App\Filament\Resources\Brands\Schemas;

use App\Models\Branch;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\TextInput;

class BrandForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('branch_id')
                    ->label('الفروع')
                    ->required()
                    ->visible(auth()->user()->admin())
                    ->options(Branch::pluck('name', 'id')),
                TextInput::make('name')
                    ->label('البراند')
                    ->required()
                    ->maxLength(255),
                TextInput::make('description')
                    ->label('الوصف')
                    ->maxLength(255),

                Toggle::make('is_active')
                    ->label('الحالة')
                    ->visibleOn('edit')
                    ->default(true),
            ]);
    }
}
