<?php

namespace App\Filament\Resources\Brands;

use BackedEnum;
use UnitEnum;
use App\Models\Brand;
use App\Support\NavGroups;
use Filament\Tables\Table;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Support\Icons\Heroicon;
use App\Filament\Resources\Brands\Pages\EditBrand;
use App\Filament\Resources\Brands\Pages\ListBrands;
use App\Filament\Resources\Brands\Pages\CreateBrand;
use App\Filament\Resources\Brands\Schemas\BrandForm;
use App\Filament\Resources\Brands\Tables\BrandsTable;
use App\Filament\Clusters\ProductManagement\ProductManagementCluster;

class BrandResource extends Resource
{
    protected static ?string $model                         = Brand::class;
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedTag;
    protected static ?string $navigationLabel               = 'البراندات';
    protected static ?string $modelLabel                    = 'براند';
    protected static ?string $pluralModelLabel              = 'البراندات';
    protected static string|UnitEnum|null  $navigationGroup = NavGroups::PRODUCTS;
    protected static ?int $navigationSort                   = 62;
    protected static ?string $recordTitleAttribute          = 'name';

    public static function form(Schema $schema): Schema
    {
        return BrandForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return BrandsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListBrands::route('/'),
            'create' => CreateBrand::route('/create'),
            'edit' => EditBrand::route('/{record}/edit'),
        ];
    }
}
