<?php

namespace App\Filament\Resources\Branches;

use App\Filament\Resources\Branches\Pages\CreateBranch;
use App\Filament\Resources\Branches\Pages\EditBranch;
use App\Filament\Resources\Branches\Pages\ListBranches;
use App\Filament\Resources\Branches\Schemas\BranchForm;
use App\Filament\Resources\Branches\Tables\BranchesTable;
use App\Models\Branch;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class BranchResource extends Resource
{
    protected static ?string $model = Branch::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::BuildingOffice;

    protected static string|UnitEnum|null $navigationGroup = NavGroups::Dashboard;

    protected static ?string $navigationLabel = 'الفروع';

    protected static ?string $modelLabel = 'فرع';

    protected static ?string $pluralModelLabel = 'الفروع';

    protected static ?int $navigationSort = 2;

    protected static ?string $recordTitleAttribute = 'name';

    /** تظهر في القائمة فقط للمسؤول */
    public static function shouldRegisterNavigation(): bool
    {
        return user_info()?->hasRole('admin') ?? false;
    }

    /** صلاحيات الوصول للصفحات */
    public static function canViewAny(): bool
    {
        return user_info()?->hasRole('admin') ?? false;
    }

    public static function canCreate(): bool
    {
        return user_info()?->hasRole('admin') ?? false;
    }

    // public static function canEdit(EloquentModel $record): bool
    // {
    //     return user_info()?->hasRole('admin') ?? false;
    // }

    // public static function canDelete(EloquentModel $record): bool
    // {
    //     return user_info()?->hasRole('admin') ?? false;
    // }

    public static function canDeleteAny(): bool
    {
        return user_info()?->hasRole('admin') ?? false;
    }

    public static function form(Schema $schema): Schema
    {
        return BranchForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return BranchesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListBranches::route('/'),
            'create' => CreateBranch::route('/create'),
            'edit' => EditBranch::route('/{record}/edit'),
        ];
    }
}
