<?php

namespace App\Filament\Resources\BranchSettings\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\ColorColumn;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class BranchSettingsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                // شعار الفرع (فاتح)
                ImageColumn::make('logo_light_url')
                    ->label('الشعار')
                    ->square()
                    ->circular()
                    ->imageHeight(40)
                    ->defaultImageUrl(asset('images/svg/avatars/blank.svg')),

                // اسم الفرع
                TextColumn::make('branch.name')
                    ->label('اسم الفرع')
                    ->badge()
                    ->color('primary')
                    ->searchable(),

                // اللون الأساسي
                ColorColumn::make('theme_primary')
                    ->label('اللون الأساسي')
                    ->copyable(),

                // العنوان
                TextColumn::make('address')
                    ->label('العنوان')
                    ->limit(40)
                    ->tooltip(fn ($record) => $record->address)
                    ->searchable(),

                // تاريخ آخر تحديث
                TextColumn::make('updated_at')
                    ->label('آخر تحديث')
                    ->dateTime('Y-m-d H:i')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: false),
            ])
            ->defaultSort('updated_at', 'desc')
            ->recordUrl(fn ($record) => route('filament.admin.resources.branch-settings.edit', $record))
            ->recordActions([
                EditAction::make()
                    ->label('تعديل')
                    ->color('primary')
                    ->icon('heroicon-o-pencil-square'),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->label('حذف المحدد')
                        ->color('danger'),
                ]),
            ]);
    }
}
