<?php

namespace App\Filament\Resources\BranchSettings\Pages;

use App\Filament\Resources\BranchSettings\BranchSettingResource;
use App\Models\Branch;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditBranchSetting extends EditRecord
{
    protected static string $resource = BranchSettingResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // 👈 الفرع الحالي من معلومات المستخدم
        $branchId = (int) user_info('branch_id');

        // نحاول أخذ الفرع من العلاقة أولاً، وإن لم يوجد نبحث بالـ ID
        $branch = $this->record->branch ?? ($branchId ? Branch::find($branchId) : null);

        if ($branch) {
            // ✅ تحديث اسم الفرع من حقل الفورم إن وُجد
            if (! empty($data['branch_name'])) {
                $branch->name = $data['branch_name'];
            }

            // ✅ تحديث المحافظة من حقل الفورم إن وُجد
            if (! empty($data['city_id'])) {
                $branch->city_id = $data['city_id'];
            }

            $branch->save();

            // ربط إعدادات الفرع بالفرع الصحيح
            $data['branch_id'] = $branch->id;
        } else {
            // في حال لم يُعثر على الفرع لأي سبب، نحاول على الأقل ضبط branch_id
            if ($branchId) {
                $data['branch_id'] = $branchId;
            }
        }

        // هذه الحقول تخص جدول branches وليست أعمدة في branch_settings
        unset($data['branch_name'], $data['city_id']);

        return $data;
    }
}
