<?php

namespace App\Filament\Resources\BranchSettings;

use App\Filament\Resources\BranchSettings\Pages\CreateBranchSetting;
use App\Filament\Resources\BranchSettings\Pages\EditBranchSetting;
use App\Filament\Resources\BranchSettings\Pages\ListBranchSettings;
use App\Filament\Resources\BranchSettings\Schemas\BranchSettingForm;
use App\Filament\Resources\BranchSettings\Tables\BranchSettingsTable;
use App\Models\BranchSetting;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use UnitEnum;

class BranchSettingResource extends Resource
{
    protected static ?string $model = BranchSetting::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $navigationLabel = 'الاعدادات';

    protected static ?string $modelLabel = 'الاعدادات';

    protected static ?string $pluralModelLabel = 'الاعدادات';

    protected static string|UnitEnum|null $navigationGroup = NavGroups::Settings;

    protected static ?int $navigationSort = 150;

    protected static ?string $recordTitleAttribute = 'branch.name';

    /** إظهار في القائمة فقط للأدمن أو مدير الفرع */
    // public static function shouldRegisterNavigation(): bool
    // {
    //     $user = Auth::user();
    //     return $user && ($user->hasRole('admin') || $user->hasRole('branch_manager'));
    // }

    // /** صلاحيات الوصول العامة للريسورس */
    // public static function canViewAny(): bool
    // {
    //     $user = Auth::user();
    //     return $user && ($user->hasRole('admin') || $user->hasRole('branch_manager'));
    // }

    // public static function canCreate(): bool
    // {
    //     $user = Auth::user();
    //     return $user && ($user->hasRole('admin') || $user->hasRole('branch_manager'));
    // }

    // public static function canView($record): bool
    // {
    //     $user = Auth::user();
    //     if (! $user) return false;

    //     // الأدمن يرى الكل
    //     if ($user->hasRole('admin')) return true;

    //     // مدير الفرع لا يرى إلا سجلات فرعه
    //     return $user->hasRole('branch_manager') && ($record?->branch_id === $user->branch_id);
    // }

    public static function canEdit($record): bool
    {
        return static::canView($record);
    }

    public static function canDelete($record): bool
    {
        // احمِ السجل من الحذف إن رغبت؛ هنا نفس منطق العرض/التعديل
        return static::canView($record);
    }

    /** حصر النتائج على فرع المستخدم ما لم يكن أدمن */
    public static function getEloquentQuery(): Builder
    {
        $query = parent::getEloquentQuery();
        $user = Auth::user();

        if ($user && $user->hasRole('admin')) {
            return $query; // لا قيود للأدمن
        }

        // لمدير الفرع: أظهر إعدادات فرعه فقط
        return $query->where('branch_id', $user?->branch_id ?? 0);
    }

    public static function form(Schema $schema): Schema
    {
        return BranchSettingForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return BranchSettingsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListBranchSettings::route('/'),
            'create' => CreateBranchSetting::route('/create'),
            'edit' => EditBranchSetting::route('/{record}/edit'),
        ];
    }
}
