<?php

namespace App\Filament\Resources\Attendances\Schemas;

use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\DateTimePicker;

class AttendanceForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('بيانات الحضور')
                    ->schema([
                        Select::make('branch_id')
                            ->label('الفرع')
                            ->relationship('branch', 'name')
                            ->searchable()
                            ->preload()
                            ->required()
                            ->visible(fn() => auth()->user()?->hasRole('admin'))
                            ->default(
                                fn() => ! auth()->user()?->hasRole('admin')
                                    ? auth()->user()?->branch_id
                                    : null
                            ),

                        Select::make('employee_id')
                            ->label('الموظف')
                            ->relationship('employee', 'name')
                            ->searchable()
                            ->preload()
                            ->required(),

                        Select::make('work_schedule_id')
                            ->label('جدول الدوام')
                            ->relationship('workSchedule', 'name')
                            ->searchable()
                            ->preload()
                            ->placeholder('اختياري'),

                        DateTimePicker::make('check_in')
                            ->label('وقت الدخول')
                            ->required()
                            ->seconds(false)
                            ->native(false),

                        DateTimePicker::make('check_out')
                            ->label('وقت الخروج')
                            ->seconds(false)
                            ->native(false),

                        TextInput::make('worked_minutes')
                            ->label('دقائق العمل')
                            ->numeric()
                            ->minValue(0)
                            ->helperText('يحسب تلقائياً عند الإغلاق إن توفرت المعادلات'),

                        TextInput::make('late_minutes')
                            ->label('دقائق التأخير')
                            ->numeric()
                            ->default(0),

                        TextInput::make('overtime_minutes')
                            ->label('دقائق إضافي')
                            ->numeric()
                            ->default(0),

                        Toggle::make('overtime_approved')
                            ->label('الموافقة على الإضافي')
                            ->default(false),

                        Select::make('source')
                            ->label('المصدر')
                            ->options([
                                'manual' => 'يدوي',
                                'device' => 'جهاز',
                                'import' => 'استيراد',
                            ])
                            ->default('manual'),

                        Select::make('status')
                            ->label('الحالة')
                            ->options([
                                'pending' => 'قيد المراجعة',
                                'confirmed' => 'مؤكد',
                                'rejected' => 'مرفوض',
                            ])
                            ->default('confirmed'),

                        Textarea::make('notes')
                            ->label('ملاحظات')
                            ->columnSpanFull(),
                    ])
                    ->columns(2)
                    ->columnSpanFull(),
            ]);
    }
}
