<?php

namespace App\Filament\Resources\Attendances;

use App\Models\Attendance;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;
use App\Filament\Resources\Attendances\Tables\AttendancesTable;
use App\Filament\Resources\Attendances\Schemas\AttendanceForm;
use App\Filament\Resources\Attendances\Pages\ListAttendances;
use App\Filament\Resources\Attendances\Pages\CreateAttendance;
use App\Filament\Resources\Attendances\Pages\EditAttendance;

class AttendanceResource extends Resource
{
    protected static ?string $model = Attendance::class;
    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;
    protected static ?string $navigationLabel = 'الحضور والانصراف';
    protected static ?string $modelLabel = 'حضور';
    protected static ?string $pluralModelLabel = 'الحضور والانصراف';
    protected static string|UnitEnum|null $navigationGroup = NavGroups::MEMBERS;
    protected static ?int $navigationSort = 14;

    public static function form(Schema $schema): Schema
    {
        return AttendanceForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AttendancesTable::configure($table);
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAttendances::route('/'),
            'create' => CreateAttendance::route('/create'),
            'edit' => EditAttendance::route('/{record}/edit'),
        ];
    }
}
