<?php

namespace App\Filament\Resources\Absences\Tables;

use Filament\Actions\ActionGroup;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Table;

class AbsencesTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('employee.name')
                    ->label('الموظف')
                    ->sortable()
                    ->searchable()
                    ->weight('bold'),
                TextColumn::make('branch.name')
                    ->label('الفرع')
                    ->sortable()
                    ->toggleable(),
                TextColumn::make('date')
                    ->label('التاريخ')
                    ->date('Y-m-d')
                    ->sortable(),
                TextColumn::make('type')
                    ->label('النوع')
                    ->badge()
                    ->formatStateUsing(fn(string $state) => match ($state) {
                        'unpaid' => 'غير مدفوع',
                        'paid' => 'مدفوع',
                        'sick' => 'مرضي',
                        'vacation' => 'إجازة',
                        'other' => 'أخرى',
                        default => $state,
                    }),
                TextColumn::make('minutes_expected')
                    ->label('دقائق متوقعة')
                    ->alignEnd()
                    ->toggleable(),
                TextColumn::make('minutes_excused')
                    ->label('دقائق معذور')
                    ->alignEnd()
                    ->toggleable(),
            ])
            ->defaultSort('date', 'desc')
            ->filters([
                SelectFilter::make('branch_id')
                    ->label('الفرع')
                    ->relationship('branch', 'name')
                    ->visible(fn() => auth()->user()?->hasRole('admin')),
                SelectFilter::make('employee_id')
                    ->label('الموظف')
                    ->relationship('employee', 'name')
                    ->searchable(),
                SelectFilter::make('type')
                    ->label('النوع')
                    ->options([
                        'unpaid' => 'غير مدفوع',
                        'paid' => 'مدفوع',
                        'sick' => 'مرضي',
                        'vacation' => 'إجازة',
                        'other' => 'أخرى',
                    ]),
            ])
            ->recordActions([
                ActionGroup::make([
                    EditAction::make(),
                    DeleteAction::make(),
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
