<?php

namespace App\Filament\Resources\Absences\Schemas;

use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Forms\Components\DatePicker;

class AbsenceForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Section::make('بيانات الغياب')
                    ->schema([
                        Select::make('branch_id')
                            ->label('الفرع')
                            ->relationship('branch', 'name')
                            ->searchable()
                            ->preload()
                            ->required()
                            ->visible(fn() => auth()->user()?->hasRole('admin'))
                            ->default(
                                fn() => ! auth()->user()?->hasRole('admin')
                                    ? auth()->user()?->branch_id
                                    : null
                            ),

                        Select::make('employee_id')
                            ->label('الموظف')
                            ->relationship('employee', 'name')
                            ->searchable()
                            ->preload()
                            ->required(),

                        DatePicker::make('date')
                            ->label('التاريخ')
                            ->native(false)
                            ->required(),

                        Select::make('type')
                            ->label('النوع')
                            ->options([
                                'unpaid' => 'غير مدفوع',
                                'paid' => 'مدفوع',
                                'sick' => 'مرضي',
                                'vacation' => 'إجازة',
                                'other' => 'أخرى',
                            ])
                            ->required(),

                        TextInput::make('minutes_expected')
                            ->label('الدقائق المتوقعة')
                            ->numeric()
                            ->minValue(0)
                            ->required(),

                        TextInput::make('minutes_excused')
                            ->label('الدقائق المعذور عنها')
                            ->numeric()
                            ->minValue(0)
                            ->default(0),

                        Textarea::make('notes')
                            ->label('ملاحظات')
                            ->columnSpanFull(),
                    ])
                    ->columns(2)
                    ->columnSpanFull(),
            ]);
    }
}
