<?php

namespace App\Filament\Pages;

use App\Filament\Widgets\Statistics;
use App\Support\NavGroups;
use BackedEnum;
use Filament\Pages\Dashboard as BaseDashboard;
use Filament\Support\Icons\Heroicon;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use UnitEnum;

class Dashboard extends BaseDashboard
{
    use BaseDashboard\Concerns\HasFiltersForm;
    use InteractsWithPageFilters;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::ChartBar;

    protected static string|UnitEnum|null $navigationGroup = NavGroups::Dashboard;

    protected static ?string $navigationLabel = 'لوحة التحكم';

    protected static ?string $modelLabel = 'الاحصائيات';

    protected static ?string $pluralModelLabel = 'الاحصائيات';

    protected static ?int $navigationSort = 1;

    protected static ?string $recordTitleAttribute = 'name';

    public function getWidgets(): array
    {
        return [
            Statistics::class,
        ];
    }
}
