<?php

namespace App\Filament\Pages\Auth;

use App\Models\User;

use Filament\Actions\Action;
use Filament\Schemas\Components\Form;
use Filament\Schemas\Schema;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Hash;
use Filament\Forms\Components\Checkbox;
use Filament\Forms\Components\TextInput;
use Filament\Auth\Pages\Login as BaseLogin;
use Filament\Auth\Http\Responses\LoginResponse;
use Illuminate\Support\HtmlString;

class Login extends BaseLogin
{
    public function form(Schema $schema): Schema
    {
        return $schema->schema([
            TextInput::make('username')
                ->label('اسم المستخدم')
                ->required()
                ->autocomplete('username')
                ->autofocus(),

            // زر نسيت كلمة السر
            TextInput::make('password')
                ->label(__('filament-panels::auth/pages/login.form.password.label'))
                ->hint(filament()->hasPasswordReset() ? new HtmlString(Blade::render('<x-filament::link :href="filament()->getRequestPasswordResetUrl()" tabindex="3"> {{ __(\'filament-panels::auth/pages/login.actions.request_password_reset.label\') }}</x-filament::link>')) : null)
                ->password()
                ->revealable(filament()->arePasswordsRevealable())
                ->autocomplete('current-password')
                ->required()
                ->extraInputAttributes(['tabindex' => 2]),

            Checkbox::make('remember')
                ->label('تذكرني'),
        ]);
    }

    public function authenticate(): ?LoginResponse
    {
        $this->validate();

        $data       = $this->form->getState();
        $remember   = (bool)($data['remember'] ?? false);

        // التحقق من اسم المستخدم
        $user = User::where('username', $data['username'] ?? null)->first();
        if (! $user) {
            $this->addError('data.username', __('auth.failed'));
            return null;
        }

        // التحقق من كلمة المرور
        if (! Hash::check($data['password'] ?? '', $user->password)) {
            $this->addError('data.password', __('auth.failed'));
            return null;
        }

        // تسجيل الدخول
        Auth::login($user, $remember);
        session()->regenerate();

        return app(LoginResponse::class);
    }
}
