<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Events\AfterSheet;

class StatisticsExport implements FromCollection, ShouldAutoSize, WithEvents, WithHeadings, WithMapping, WithTitle
{
    public function __construct(
        protected array $rows,
        protected array $meta = []
    ) {}

    public function title(): string
    {
        return 'الإحصائيات';
    }

    public function headings(): array
    {
        return [
            'الإحصائية',
            'القيمة',
            'العدد',
            'مقارنة مع اليوم',
            'فرق',
        ];
    }

    public function collection(): Collection
    {
        // rows عندك associative array، نخليه list
        return collect(array_values($this->rows));
    }

    public function map($row): array
    {
        $cmp = $row['cmp'] ?? null;

        return [
            (string) ($row['title'] ?? ''),
            (int) ($row['total'] ?? 0),
            (int) ($row['count'] ?? 0),
            (string) (($cmp['text'] ?? '') ?: ''),
            (int) ($cmp['diff'] ?? 0),
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                $period = (string) ($this->meta['period_label'] ?? '');
                $range = (string) ($this->meta['range_label'] ?? '');
                $cmpOn = (bool) ($this->meta['comparison'] ?? false);

                $sheet->insertNewRowBefore(1, 3);

                $sheet->setCellValue('A1', 'تقرير الإحصائيات');
                $sheet->setCellValue('A2', "الفترة: {$period} | {$range}");
                $sheet->setCellValue('A3', 'المقارنة: '.($cmpOn ? 'مفعّلة (مع اليوم)' : 'غير مفعّلة'));

                $sheet->mergeCells('A1:E1');
                $sheet->mergeCells('A2:E2');
                $sheet->mergeCells('A3:E3');

                $sheet->getStyle('A1:A3')->getFont()->setBold(true);

                // Heading row صار عندنا بالصف 4
                $sheet->getStyle('A4:E4')->getFont()->setBold(true);

                // أرقام صحيحة
                $sheet->getStyle('B:B')->getNumberFormat()->setFormatCode('#,##0');
                $sheet->getStyle('C:C')->getNumberFormat()->setFormatCode('#,##0');
                $sheet->getStyle('E:E')->getNumberFormat()->setFormatCode('#,##0');
            },
        ];
    }
}
