<?php

namespace App\Enums;

enum UserType: string
{
    case DAILY   = 'daily';   // موظف بأجر يومي
    case MONTHLY = 'monthly'; // موظف براتب شهري

    public function label(): string
    {
        return match ($this) {
            self::DAILY   => 'أجر يومي',
            self::MONTHLY => 'راتب شهري',
        };
    }

    public static function options(): array
    {
        return [
            self::DAILY->value   => self::DAILY->label(),
            self::MONTHLY->value => self::MONTHLY->label(),
        ];
    }
}
