<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * طرق الشحن
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum ShippingMethod: string
{
    case SelfDelivery = 'self';    // توصيل داخلي
    case Company = 'company'; // شركة شحن

    public function label(): string
    {
        return match ($this) {
            self::SelfDelivery => 'توصيل داخلي',
            self::Company => 'شركة شحن',
        };
    }

    public function icon(): string
    {
        return match ($this) {
            self::SelfDelivery => 'heroicon-o-truck',
            self::Company => 'heroicon-o-building-office',
        };
    }

    public static function options(): array
    {
        return collect(self::cases())
            ->mapWithKeys(fn (self $method) => [$method->value => $method->label()])
            ->all();
    }
}
