<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * طرق الاسترداد
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum RefundMethod: string
{
    case CASH = 'cash';                       // نقد
    case CREDIT_NOTE = 'credit_note';         // إشعار دائن
    case BANK_TRANSFER = 'bank_transfer';     // تحويل بنكي
    case REPLACEMENT = 'replacement';         // استبدال

    public function label(): string
    {
        return match ($this) {
            self::CASH => 'نقد',
            self::CREDIT_NOTE => 'إشعار دائن',
            self::BANK_TRANSFER => 'تحويل بنكي',
            self::REPLACEMENT => 'استبدال',
        };
    }
}
