<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * حالات استلام العنصر
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum ReceiveStatus: string
{
    case PENDING = 'pending';     // بانتظار الاستلام
    case PARTIAL = 'partial';     // استلام جزئي
    case RECEIVED = 'received';   // مستلم كاملاً

    public function label(): string
    {
        return match ($this) {
            self::PENDING => 'بانتظار الاستلام',
            self::PARTIAL => 'استلام جزئي',
            self::RECEIVED => 'مستلم',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::PENDING => 'gray',
            self::PARTIAL => 'yellow',
            self::RECEIVED => 'green',
        };
    }
}
