<?php

namespace App\Enums;

enum ReceiptStatus: string
{
    case ISSUED   = 'issued';
    case POSTED   = 'posted';
    case CANCELED = 'canceled';
    case REVERSED = 'reversed';

    public function label(): string
    {
        return match ($this) {
            self::ISSUED   => 'مُصدر',
            self::POSTED   => 'معتمد',
            self::CANCELED => 'ملغى',
            self::REVERSED => 'معكوس',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::ISSUED   => 'warning',
            self::POSTED   => 'success',
            self::CANCELED => 'danger',
            self::REVERSED => 'danger',
        };
    }

    public function icon(): string
    {
        return match ($this) {
            self::ISSUED   => 'heroicon-o-document-text',
            self::POSTED   => 'heroicon-o-check-circle',
            self::CANCELED => 'heroicon-o-x-circle',
            self::REVERSED => 'heroicon-o-arrow-path',
        };
    }

    public static function options(): array
    {
        return [
            self::ISSUED->value   => self::ISSUED->label(),
            self::POSTED->value   => self::POSTED->label(),
            self::CANCELED->value => self::CANCELED->label(),
            self::REVERSED->value => self::REVERSED->label(),
        ];
    }

    public static function values(): array
    {
        return array_map(fn($c) => $c->value, self::cases());
    }
}
