<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * حالات المرتجع
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum PurchaseReturnStatus: string
{
    case PENDING = 'pending';       // معلق
    case APPROVED = 'approved';     // موافق عليه
    case COMPLETED = 'completed';   // مكتمل
    case REJECTED = 'rejected';     // مرفوض

    public function label(): string
    {
        return match ($this) {
            self::PENDING => 'معلق',
            self::APPROVED => 'موافق عليه',
            self::COMPLETED => 'مكتمل',
            self::REJECTED => 'مرفوض',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::PENDING => 'yellow',
            self::APPROVED => 'blue',
            self::COMPLETED => 'green',
            self::REJECTED => 'red',
        };
    }
}
