<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * حالات فاتورة المشتريات
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum PurchaseInvoiceStatus: string
{
    case DRAFT      = 'draft';           // مسودة
    case PENDING    = 'pending';       // معلقة (بانتظار الاستلام)
    case PARTIAL    = 'partial';       // استلام جزئي
    case RECEIVED   = 'received';     // مستلمة كاملة
    case CANCELLED  = 'cancelled';   // ملغاة

    public function label(): string
    {
        return match ($this) {
            self::DRAFT      => 'مسودة',
            self::PENDING    => 'معلقة',
            self::PARTIAL    => 'استلام جزئي',
            self::RECEIVED   => 'مستلمة',
            self::CANCELLED  => 'ملغاة',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::DRAFT         => 'gray',
            self::PENDING       => 'yellow',
            self::PARTIAL       => 'blue',
            self::RECEIVED      => 'green',
            self::CANCELLED     => 'red',
        };
    }
}
