<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * أنواع العروض والخصومات
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum PromotionType: string
{
    case Percentage = 'percentage';          // نسبة مئوية
    case Fixed = 'fixed';               // مبلغ ثابت
    case BuyXGetY = 'buy_x_get_y';         // اشتري X واحصل على Y مجاناً
    case FreeShipping = 'free_shipping';       // شحن مجاني
    case MinPurchaseDiscount = 'min_purchase_discount'; // خصم عند حد أدنى للشراء

    public function label(): string
    {
        return match ($this) {
            self::Percentage => 'نسبة مئوية',
            self::Fixed => 'مبلغ ثابت',
            self::BuyXGetY => 'اشتري واحصل مجاناً',
            self::FreeShipping => 'شحن مجاني',
            self::MinPurchaseDiscount => 'خصم حد أدنى',
        };
    }

    public function description(): string
    {
        return match ($this) {
            self::Percentage => 'خصم نسبة مئوية من إجمالي الطلب',
            self::Fixed => 'خصم مبلغ ثابت من إجمالي الطلب',
            self::BuyXGetY => 'اشتري عدد معين واحصل على منتج مجاناً',
            self::FreeShipping => 'شحن مجاني عند تحقيق شرط معين',
            self::MinPurchaseDiscount => 'خصم عند الوصول لحد أدنى من المشتريات',
        };
    }

    public function icon(): string
    {
        return match ($this) {
            self::Percentage => 'heroicon-o-receipt-percent',
            self::Fixed => 'heroicon-o-banknotes',
            self::BuyXGetY => 'heroicon-o-gift',
            self::FreeShipping => 'heroicon-o-truck',
            self::MinPurchaseDiscount => 'heroicon-o-shopping-cart',
        };
    }

    public static function options(): array
    {
        return collect(self::cases())
            ->mapWithKeys(fn (self $type) => [$type->value => $type->label()])
            ->all();
    }

    /**
     * هل يتطلب هذا النوع قيمة خصم؟
     */
    public function requiresDiscountValue(): bool
    {
        return in_array($this, [
            self::Percentage,
            self::Fixed,
            self::MinPurchaseDiscount,
        ]);
    }

    /**
     * هل يتطلب هذا النوع حقول الكميات (buy_quantity, get_quantity)؟
     */
    public function requiresQuantityFields(): bool
    {
        return $this === self::BuyXGetY;
    }
}
