<?php

namespace App\Enums;

/**
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 * نطاق تطبيق العرض
 * ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 */
enum PromotionAppliesTo: string
{
    case All = 'all';      // جميع المنتجات
    case Product = 'product';  // منتجات محددة
    case Category = 'category'; // تصنيفات محددة
    case Brand = 'brand';    // براندات محددة

    public function label(): string
    {
        return match ($this) {
            self::All => 'جميع المنتجات',
            self::Product => 'منتجات محددة',
            self::Category => 'تصنيفات محددة',
            self::Brand => 'براندات محددة',
        };
    }

    public function icon(): string
    {
        return match ($this) {
            self::All => 'heroicon-o-globe-alt',
            self::Product => 'heroicon-o-cube',
            self::Category => 'heroicon-o-tag',
            self::Brand => 'heroicon-o-building-storefront',
        };
    }

    public static function options(): array
    {
        return collect(self::cases())
            ->mapWithKeys(fn (self $type) => [$type->value => $type->label()])
            ->all();
    }

    /**
     * هل يتطلب هذا النوع تحديد عناصر معينة؟
     */
    public function requiresSelection(): bool
    {
        return $this !== self::All;
    }
}
